
		QLAYT	QL emulator tools for DOS/Linux


Version 0.90, 19990130

1. Copyrights

This program is freeware. You may do with it whatever you want for personal use.
Copyright Jan Venema.

Permission is granted to redistribute this program free of charge, provided it
is distributed in the full archive with unmodified contents. No profit beyond
the price of the media on which it is distributed is made.

There are no warranties of any kind for this program. If you use this program,
you do so at your own risk. The author is not responsible for any damages
that might result from using this program.


2. Overview

QLAYT provides a set of tools and general support functions for the QL
emulator QLAY. The tools are needed because the QL and it's operating
system QDOS have some pecularities that do not match well with most
other Operating Systems. Most obvious difference is that QDOS files consist
of two parts: a header block and the actual data file. To allow transparent
access from the emulator program to the native file system it's needed
that the file header is stored separately.

The QLAYT program takes care of inserting or extracting files into/from
a directory file. It knows about datasize fields. And will import and
export files from other QDOS compatible systems and QLAY's MDV file format.

QLAY uses a directory file -called qlay.dir- to store the headers of all
files that it needs to access during emulation. The stored headers are
similar to the QDOS header: for each file a 64 byte data field is used.
The header block maintains the file length (header inclusive), the
file name (up 36 character), the modification date and an optional data
size field.

Before QLAY can access any files, their headers must be constructed in the
file 'qlay.dir'. Any file in the native directory stored in 'qlay.dir' can be
accessed during emulation as on a real QL. All other files are simply
invisible for QLAY.

A tricky part is setting the correct datasizes for an executable QDOS
program. Some executable files have the datasize stored in a XTcc field
in the file itself. QLAYT can use those.
Another way to get the value is from a InfoZIP archive file that was
archived with a QDOS compatible ZIP program. QLAYT can read those datasizes.
Of course, you can also unzip a file in the QLAY emulator with the
QDOS InfoZIP 'unzip'. (It has a proper XTcc field :-)
If all else fails, simply try it with a reasonably large number...

NOTE: QLAY does not support sub-directories of any kind (yet).

QLAY uses a 'MDV' file format to emulate the Microdrive cartridges. Each
cartridge is store as in a single file. It has a format very much like the
magnetic bit pattern found on the end-less tape inside the QL cartridges.
The file is not end-less (!), but wraps around after 174930 bytes exactly.
QLAYT has options to import and export files from a 'MDV' file.
The 4 original PSION cartridges are already converted and available
on my website.

NOTE: there is no option in QLAYT to get an **exact** copy of a QL
cartridge (yet).

Since there are several QL compatible systems and various file storage
formats QLAYT has also some functions to extract files and header
information. It can extract files from QLAY's own MDV file format,
from QXL disk images (untested) and can read file headers from QDOS files
compressed in an InfoZip archive.


3. Invocation, options and use

QLAYT exists in DOS and Linux versions. The DOS file is 'qlayt.exe'; the
Linux version 'qlayt'. Both version have the exact same options and use.
Invoked without options QLAYT will show help text.
The default directory file for directory operations is 'qlay.dir'.

3.1 Command line options

-l	List the contents of the directory file. The output can be
	redirected to a file for later use. See 'use' section below.

-c file Create a new QLAY directory file. All files listed in 'file'
	are included.

-a file Append to an existing QLAY directory file. All files listed in
	'file' are appended.

-i file	Include a single DOS/Linux 'file' in the QLAY directory file.

-r file Remove a single DOS/Linux 'file' from the QLAY directory file. The
	file itself is not removed.

-u file	Update the header information for 'file'. This action is needed
	when a file, listed in the QLAY directoy file, is modified by a
	DOS/Linux editor or so. The file length and other header data may
	have changed.

-d size	To be used together with option -i. Specifies the datasize for
	executable files. Specify size as decimal number.

-X	To be used together with option -i. QLAYT will try to find a XTcc
	datasize field in the file. This is often available in modern
	compiled QDOS programs.

-x file Show the XTcc field of 'file'. The datasize, if found, will be
	shown. The QLAY directory file will not be updated.

-z file Show the QDOS headers in a ZIP 'file'. QDOS files that were archived
	in a ZIP file with InfoZip and QDOS extensions will store the
	header internally. The headers, if found, will be shown. The output
	can be redirected to a file for later use. See 'use' section below.
	The QLAY directory file will not be updated.

-q file	Use 'file' as the QLAY directory file; this in stead of the default
	directory file 'qlay.dir'.

-W file	Write all files contained in an MDV 'file' to the current directory,
	and store the header information in file 'qlay.dir'.
	The default 'qlay.dir' can be changed with option -q.
	QDOS has different rules for filenames and their length than DOS or
	Linux. For this reason some files may be renamed with a legal
	DOS/Linux file name.

-C file Create an MDV image file from the files listed in 'file'. The
        MDV image file will be stored as 'qlay.mdv'. This default can be
	changed with option 'o'.

-R hex  Insert a random sector number on MDV file. Use together with -C.
	hex must be a hexadecimal value 0 <= hex <= ffff.

-o file Use 'file' as the MDV image file; this in stead of the default
	'qlay.dir'.

-E file	Extract all files contained in an QXL disk image 'file' to the
	current directory, and store the header information in file
	'qlay.dir'.
	The default 'qlay.dir' can be changed with option -q.
	QDOS has different rules for filenames and their length than DOS
	or Linux. For this reason some files may be renamed with a legal
	DOS/Linux file name. Untested: need feedback!

-m file1 file2 Convert 'file1' in the native file system (DOS or Linux) to
	a QDOS 'file2'. Specify optional datasize with:
	-d size -m file1 file2
	Specify size as decimal number.
	Us this to convert a file what needs to be sent to a real QL.

-n file1 file2 Convert QDOS 'file1' to the native file system (DOS or Linux)
	'file2'. If 'file1' contains a datasize, that will be printed in
	decimal format.
	Use this to convert a file that was received from a real QL.

Additional notes:

For all options where files are to be included in the QLAY directory file
(-c, -a, -i, and -u) those files must exist in the current DOS/Linux
directory, otherwise they will be skipped.

QLAYT will check for duplicate file names in the QLAY directory file.

QLAYT will not overwrite an existing QLAY directory file with option -c.

QLAYT must not be executed while QLAY is active! If changes need to be
made to the QLAY directory file, and those changes can not be done from
within QLAY, it is necessary to quit QLAY. After that the change can be
made with QLAYT.


3.2 Usage of QLAYT

Assume there is no QLAY directory file. To get started, create a list
of files that needs to be accessed from QLAY.

The list can be generated with the following command:
DOS	dir/b > qlay.lst
Linux	ls > qlay.lst

Edit the file qlay.lst as needed.

	qlayt -c qlay.lst	creates a 'qlay.dir' file

Check the contents with:

	qlayt -l

The files listed are now available for access by the QLAY emulator.

Suppose you have a single file 'abc.txt' to be added to the list. Use:

	qlayt -i abc.txt

If file 'clock_exe' is a QDOS executable you might try:

	qlayt -i clock_exe -X

Or if that fails, and you happen to know the correct datasize (e.g. 1024):

	qlayt -i clock_exe -d 1024

It also possible to use the information from 'qlay.dir':
Suppose a InfoZIP file was decompressed by the QLAY emulator. Then
all file headers are stored in 'qlay.dir'. That information can be
stored in ASCII format with:

	qlayt -l > qlay.lst

The 'qlay.lst' file can than later be used to generate another directory file:

	qlayt -a qlay.lst
or
	qlayt -c qlay.lst

To extract all files from a QXL disk image file called 'qxlfile':
Method 1:
	qlayt -E qxlfile > qlay.lst
	qlayt -c qlay.lst

Method 2:
	qlayt -E qxlfile
	rename qxl.dir qlay.dir

Method 3:
	qlayt -E qxlfile -q qlay.dir


4. History

090c	added random sector number for MDV; option -R
083a	added QDOS <-> DOS file conversion (chop/generate 64 byte header)
	added Linux version
082f	first release

The QLAYT program is a combination of the separate programs that came with
earlier distributions of QLAY: fil2mdv, dos2qdos, qdos2dos and fil2win.

Main difference is that all options use the same file format. QLAYT never
expects the QDOS header to be part of a file when operating under MS-DOS
or Linux.
All file header information is kept the directory file 'qlay.dir'.

5. Known bugs, non-features
- QLAYT was developed under Win95 and may be less usable on a '8.3' file
  system like Win31 or OS/2 in DOS box. Expect a solution later.
- QLAYT does not handle improper filename characters or spaces in filename.

6. Info and updates

http://www.inter.nl.net/hcc/A.Jaw.Venema
A.Jaw.Venema@net.hcc.nl

Jan Venema
